#define highscore_load
// highscore_load(filename)
// v1.00

// PLEASE READ THE INTRODUCTION BELOW BEFORE USING THIS SCRIPT!

// This will load a highscore table from the given filename!
// Filename should contain the extension (eg. "highscore1.dat").
// Filename can also contain the whole path (eg. "C:\Program files\MyGame\data2.dat")
// or otherwise the file is loaded from the working directory.
// NOTE: The previous highscore WILL be cleared! You can save it using highscore_save()
// before calling this script! If the given filename doesn't exist or the loading
// fails the highscore is cleared anyway!
// This script returns whether the loading succeeds (true or false).

var filename, filehandle, str, val; // Define temporary variables required.

filename = argument0;
if not is_string(filename) // Checks whether the given filename is valid.
    return false;
 
highscore_clear(); // Clear the previous highscore table.

if not file_exists(filename) // Checks whether the given filename exists!
    return false;
 
filehandle = file_text_open_read(filename); // Opens the file for reading!

while (not file_text_eof(filehandle)) { // Start the "reading loop".

    str = file_text_read_string(filehandle); // Read a player name as string
 
    file_text_readln(filehandle); // Skip the rest of the line
 
     // Check whether there are still lines left
    if not file_text_eof(filehandle) and string_length(str) > 0 {
    
        val = file_text_read_string(filehandle); // Read a score value AS STRING!
        
        file_text_readln(filehandle); // Skip the rest of the line
        
        // Check whether the score doesn't contain any forbitten characters!
        if (string_digits(val) == val and string_length(val) > 0) {

            // The name-score pair should be OK! Add it to the highscore table!
            highscore_add(str,real(val));

        }

    }
    
    // Now, if there are any lines left the loop will start from beginning!
 
} // End the "reading loop"

file_text_close(filehandle); // Closes the file!

return true; // Everything is OK. Return succesfull :)

// This script is made by Kimmo "Waspwort" Kiiski, 2005 and if you use
// or modify this in your game it would be nice if you credit me.
#define highscore_save
// highscore_save(filename)
// v1.00

// PLEASE READ THE INTRODUCTION BELOW BEFORE USING THIS SCRIPT!

// This will save the current highscore table in the given filename!
// Filename should contain the extension (eg. "highscore1.dat").
// Filename can also contain the whole path (eg. "C:\Program files\MyGame\data2.dat")
// or otherwise the file is saved in the working directory.
// If the given filename already exists it will be overwritten!
// This script returns whether the writing succeeds (true or false).

var filename, tempfile, filehandle, t; // Define temporary variables required.

// NOTE: The higshcore will be FIRST saved in the temorary file,
// THEN copied to the given filename!!!
tempfile = temp_directory+"\temphighscore.tmp"; // Define the temporary filename

filename = argument0;
if not is_string(filename) // Checks whether the given filename is valid.
    return false;

filehandle = file_text_open_write(tempfile) // Open the temp file for writing!

for (t=1; t<=10; t+=1) { // Handle the highscore places from 1 to 10.

    file_text_write_string(filehandle,highscore_name(t)) // Write the player name
    file_text_writeln(filehandle) // Start a new line
    file_text_write_string(filehandle,string(highscore_value(t))) // Write the score as string
    file_text_writeln(filehandle) // Start a new line
 
} // End FOR

file_text_close(filehandle); // Close the file.

if not file_copy(tempfile,filename) // Copy the temp file to the given filename!
    return false; // Copying failed!

file_delete(tempfile); // Finally delete the temporary file.

return true; // Everything is OK. Return succesfull.

// This script is made by Kimmo "Waspwort" Kiiski, 2005 and if you use
// or modify this in your game it would be nice if you credit me.
